﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
''' <summary>
''' 由于基类型 SystemValueType.Long 不从 System.Object 继承，对泛型类调用 
''' ToArray() 时，不能从 System.Object[] 强制转换为 Int64[]。因此，我们将创建
''' 自己的 long 类，以便能够从 System.Object 的数组强制转换为 LongClass 的数组。
''' </summary>
''' <remarks></remarks>
Public Class LongClass
    Implements IComparable

    Public Sub New(ByVal l As Long)
        v = l
    End Sub

    Private v As Long

    Public Property Value() As Long
        Get
            Return v
        End Get
        Set(ByVal Value As Long)
            v = Value
        End Set
    End Property

    Public Overrides Function ToString() As String
        Return v.ToString()
    End Function

    ''' <summary>
    ''' CompareTo 函数是 IComarable 接口的实现。
    ''' 对于 customer 类，我们仅实现 ID 字段的比较。
    ''' 这意味着对这些对象的数组或集合所执行的任何排序
    ''' 都将依据客户 ID 执行。
    ''' </summary>
    Public Function CompareTo(ByVal obj As Object) As Integer Implements IComparable.CompareTo

        ' 首先检查以确保正在将此实例与另一个 MyLong 进行比较。
        If TypeOf obj Is LongClass Then
            ' 创建强类型的 obj 实例。
            Dim l As LongClass
            l = CType(obj, LongClass)

            If l.Value = Me.Value Then
                Return 0
            ElseIf l.Value < Me.Value Then
                Return 1
            Else
                Return -1
            End If
        Else
            Throw New ArgumentException("LongClass instances can only be compared to other LongClass instances.")
        End If
    End Function

End Class
